<?php
class ControllerSaleCombineCustomer extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('sale/combine_customer');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/combine_customer');
		
		$data['heading_title'] = $this->language->get('heading_title');
		
		$data['entry_pri_customer_id'] = $this->language->get('entry_pri_customer_id');
		$data['entry_sec_customer_id'] = $this->language->get('entry_sec_customer_id');
		
		$data['text_combine_customer'] = $this->language->get('text_combine_customer');
		$data['text_customer_group'] = $this->language->get('text_customer_group');
		$data['text_full_name'] = $this->language->get('text_full_name');
		$data['text_telephone'] = $this->language->get('text_telephone');
		$data['text_email'] = $this->language->get('text_email');
		$data['text_reward_total'] = $this->language->get('text_reward_total');
		$data['text_total_reward'] = $this->language->get('text_total_reward');
		$data['text_activity_history'] = $this->language->get('text_activity_history');
		$data['text_total_activity'] = $this->language->get('text_total_activity');
		$data['text_total_order'] = $this->language->get('text_total_order');
		$data['text_total_address'] = $this->language->get('text_total_address');
		$data['text_total_ip_addresses'] = $this->language->get('text_total_ip_addresses');
		$data['text_total_return'] = $this->language->get('text_total_return');
		$data['text_coupon_history'] = $this->language->get('text_coupon_history');
		$data['text_transection_total'] = $this->language->get('text_transection_total');
		$data['text_total_transection'] = $this->language->get('text_total_transection');
		$data['text_total_online'] = $this->language->get('text_total_online');
		$data['text_total_review'] = $this->language->get('text_total_review');
		$data['text_cart'] = $this->language->get('text_cart');

		$data['token'] = $this->session->data['token'];
		
		$data['help_customer_id'] = $this->language->get('help_customer_id');
		$data['help_note'] = $this->language->get('help_note');
		
		$data['column_primary_account_detail'] = $this->language->get('column_primary_account_detail');
		$data['column_secondary_account_detail'] = $this->language->get('column_secondary_account_detail');
		$data['column_result'] = $this->language->get('column_result');
		$data['column_fields'] = $this->language->get('column_fields');		

		$data['button_search_customer'] = $this->language->get('button_search_customer');
		$data['button_combine'] = $this->language->get('button_combine');
		
		
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('sale/combine_customer', 'token=' . $this->session->data['token'], 'SSL')
		);
		
		if (isset($this->request->get['primary_customer_id'])) {
			$data['primary_customer_id'] = $this->request->get['primary_customer_id'];
		} else {
			$data['primary_customer_id'] = NULL;
		}
		
		if (isset($this->request->get['secondary_customer_id'])) {
			$data['secondary_customer_id'] = $this->request->get['secondary_customer_id'];
		} else {
			$data['secondary_customer_id'] = NULL;
		}

		$data['customer_id_link'] = $this->url->link('sale/customer', 'token=' . $this->session->data['token'], 'SSL');
		
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['header'] = $this->load->controller('common/header');
		$data['footer'] = $this->load->controller('common/footer');
		$this->response->setOutput($this->load->view('sale/combine_customer.tpl', $data));
	}
	
	public function getCustomerDetail(){
		$json = array();
		$this->load->model('sale/combine_customer');
		$primary_customer_id = $this->request->get['primary_customer_id'];
		$secondary_customer_id = $this->request->get['secondary_customer_id'];
		$primary_customer_info = $this->model_sale_combine_customer->getCustomer($primary_customer_id);
			
		if (!empty($primary_customer_info)) {
			$json['primary_customer_name']= $primary_customer_info['firstname'] . $primary_customer_info['lastname'];
			$json['primary_customer_email']= $primary_customer_info['email'];
			$json['primary_customer_telephone']= $primary_customer_info['telephone'];
			$json['primary_customer_group']= $primary_customer_info['customer_group'];
			$cart = unserialize($primary_customer_info['cart']);
			$total_item = 0;
			if($cart) {
				foreach ($cart as $key => $quantity){
					$total_item += $quantity;
				}
			}
			$json['primary_cart']= $total_item;
		}else{
			$json['primary_customer_name']= '';
			$json['primary_customer_email']= '';
			$json['primary_customer_telephone']= '';
			$json['primary_customer_group']= '';
			$json['primary_cart']= 0;
		}
		if (!empty($primary_customer_info)) {
			$json['result_customer_name']= $primary_customer_info['firstname'] . $primary_customer_info['lastname'];
			$json['result_customer_email']= $primary_customer_info['email'];
			$json['result_customer_telephone']= $primary_customer_info['telephone'];
			$json['result_customer_group']= $primary_customer_info['customer_group'];

		}else{
			$json['result_customer_name']= '';
			$json['result_customer_email']= '';
			$json['result_customer_telephone']= '';
			$json['result_customer_group']= '';
		}

		$counter = array();
		$result = $this->model_sale_combine_customer->getCustomerDetail($primary_customer_id);
		foreach($result as $key=>$value){
			$json['primary_'.$value['type']] = (int)$value['total'];
			$counter[$value['type']] = $value['type'];
		}
			
		$secondary_customer_info = $this->model_sale_combine_customer->getCustomer($secondary_customer_id);
			
		if (!empty($secondary_customer_info)) {
			$cart = unserialize($secondary_customer_info['cart']);
			$total_item = 0;
			if($cart) {
				foreach ($cart as $key => $quantity){
					$total_item += $quantity;
				}
			}
			$json['secondary_customer_name']= $secondary_customer_info['firstname'] . $secondary_customer_info['lastname'];
			$json['secondary_customer_email']= $secondary_customer_info['email'];
			$json['secondary_customer_telephone']= $secondary_customer_info['telephone'];
			$json['secondary_customer_group']= $secondary_customer_info['customer_group'];
			$cart = unserialize($secondary_customer_info['cart']);
			$total_item = 0;
			if($cart) {
				foreach ($cart as $key => $quantity){
					$total_item += $quantity;
				}
			}
			$json['secondary_cart']= $total_item;
			
		}else{
			$json['secondary_customer_name']= '';
			$json['secondary_customer_email']= '';
			$json['secondary_customer_telephone']= '';
			$json['secondary_customer_group']= '';
			$json['secondary_cart']= 0;
		}
			
		$result = $this->model_sale_combine_customer->getCustomerDetail($secondary_customer_id);
		foreach($result as $key=>$value){
			$json['secondary_'.$value['type']] = (int)$value['total']; 
		}

		if (!empty($secondary_customer_info)) {
			$json['result_customer_telephone']= $secondary_customer_info['telephone'];  
		}else{
			$json['result_customer_telephone']= '';
		}

		$json['result_cart'] = $json['primary_cart'] + $json['secondary_cart'];

		foreach($counter as $key=>$value){
			$json['result_'.$key] = $json['primary_'.$key] + $json['secondary_'.$key];
		}
		$this->response->setOutput(json_encode($json));		
	}
	
	public function combineCustomer(){
		$json = array();
		$json['success'] = 'This is beta Version You can Purchase From <a href="https://www.opencart.com/index.php?route=marketplace/extension/info&extension_id=37827">Opencart MARKETPLACE</a> or contact upencart@gmail.com'; 
		$this->response->setOutput(json_encode($json));		
	}
}